import Utilities.gui_creator as gc
import Utilities.visa_operations as vo
import numpy as np
import threading
import time

root = gc.create_window(title='Thermocouple Thermometer',
                        size='300x100')

resource_name = 'USB0::0x0957::0x0607::MY47022122::INSTR'
rm, dmm = vo.open_session(resource_name)

lbl_2 = gc.create_indicator(root,
                            label_1='Temperature (deg Celsius)')

a = 1.12622037e-03
b = 2.34560173e-04
d = 8.62708193e-08


def acquire_sample():
    
    
    while btn.cget('text') == 'Stop':

        command = 'CONF:RES 1.00e+05,7.00e-02;:INIT;:FETC?'
        vo.write_instrument(dmm, command)
        response = vo.read_instrument(dmm)
        resistance = float(response[:-1])

        x = np.log(resistance)
        inverse_kelvin = a + b*x + d*x**3
        degree_celsius = 1/inverse_kelvin - 273.15     
        
        string_temperature = f'{degree_celsius:.1f}'

        lbl_2.config(text=string_temperature)        

        time.sleep(0.25)

    return


def toggle():

    if btn.cget('text') == 'Start':
        btn.config(text = 'Stop')
    elif btn.cget('text') == 'Stop':
        btn.config(text='Start')

    t = threading.Thread(target=acquire_sample)
    t.start()

    return

btn = gc.action_button(root,label='Start',
                       action=toggle)

root.mainloop()

vo.close_session(rm, dmm)
